import requests
import json
import mysql.connector

# تحديد المعلومات اللازمة
email = "mtc9afd-01@makamat.com"  # يمكنك تغييرها بالبريد الإلكتروني الخاص بك
password = "mtc9afd-2023"  # يمكنك تغييرها بكلمة مرورك

# بناء البيانات المرسلة كنص مشفر
post_data = {
    'email': email,
    'password': password
}

# إرسال طلب POST للحصول على رمز التميز
response = requests.post(
    'https://mtc9afd-01.azurewebsites.net/api/Auth/login',
    headers={
        'Content-Type': 'application/json',
        'cache-control': 'no-cache'
    },
    json=post_data,
    verify=False  # تعطيل التحقق من الشهادة
)

# التحقق من وجود أخطاء في الطلب
if response.status_code != 200:
    print(f"خطأ في الاتصال بالخادم: {response.text}")
else:
    # تحويل الرد إلى مصفوفة جسون
    response_array = response.json()

    if 'token' in response_array:
        # استخراج الرمز المميز من الرد
        token = response_array['token']

        # عرض الرمز المميز
        print(f"token : {token}")

        # بناء الطلب الجديد للحصول على بيانات RFID
        response = requests.get(
            'https://mtc9afd-01.azurewebsites.net/api/RFIDScanData',
            headers={
                'Authorization': f'Bearer {token}',
                'Content-Type': 'application/json',
                'cache-control': 'no-cache'
            },
            verify=False  # تعطيل التحقق من الشهادة
        )

        # التحقق من وجود أخطاء في الطلب
        if response.status_code != 200:
            print(f"خطأ في الاتصال بالخادم: {response.text}")
        else:
            # تحويل الرد إلى مصفوفة جسون
            data = response.json()

            # الاتصال بقاعدة البيانات MySQL
            # الاتصال بقاعدة البيانات MySQL
            try:
                db_connection = mysql.connector.connect(
                    host="vsrv681.armadaservers.com",
                    user="mint303_change_stock",
                    password="Plmokn123@",
                    database="mint303_change_stock"
                )
                db_cursor = db_connection.cursor()

                # استعداد البيانات للإدراج
                insert_data = []

                # البحث عن القيم الموجودة في جدول آخر
                for row in data:
                    rfidScanDataId = row['rfidScanDataId']

                    # إضافة القيم إلى قائمة الإدراج
                    insert_data.append((
                        rfidScanDataId,
                        row['epc'],
                        row['tagNumber'],
                        row['assetBarcode'],
                        row['operator'],
                        row['assetType'],
                        row['readTimestamp'],
                        row['region'],
                        row['city'],
                        row['locationSpecifier'],
                        row['locationTag1'],
                        row['locationTag2'],
                        row['latitude'],
                        row['longitude'],
                        row['operation'],
                        row['scanState']
                    ))

                # الاستعلام عن القيم الموجودة بشكل دفعي
                sql_query = "SELECT rfidScanDataId FROM RFIDScanData WHERE rfidScanDataId IN (%s)" % ','.join(['%s'] * len(insert_data))
                db_cursor.execute(sql_query, [i[0] for i in insert_data])
                existing_rows = db_cursor.fetchall()

                existing_ids = set(row[0] for row in existing_rows)
                rownumber=0
                # تحديث القيمة في جدول البيانات أو إدراج القيم الجديدة
                for item in insert_data:
                    if item[0] in existing_ids:
                        rownumber+=1
                        # print(f"rownumber: {rownumber}")
                        # print(f"Existing: {item[0]}")
                    else:
                        # استعلام الإدراج
                        insert_query = "INSERT INTO RFIDScanData (rfidScanDataId , epc , tagNumber , assetBarcode , operator , assetType , readTimestamp , region , city , locationSpecifier , locationTag1 , locationTag2 , latitude , longitude , operation , scanState ) VALUES (%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)"
                        db_cursor.execute(insert_query, item)
                        rownumber+=1
                        # print(f"rownumber: {rownumber}")
                        # print(f"Does not exist: {item[0]}")

                # تأكيد التغييرات
                db_connection.commit()
                print("The data has been updated successfully")

            except mysql.connector.Error as error:
                print(f"An error occurred while connecting to the database: {error}")

            

            finally:
                # إغلاق الاتصال بقاعدة البيانات
                if (db_connection.is_connected()):
                    db_cursor.close()
                    db_connection.close()
                    print("The connection to the database has been closed")

    else:
        print(f"An error occurred in obtaining the token: {response.text}")
