<?php
require 'vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Alignment;

$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();

// تعيين البيانات في الجدول
$sheet->setCellValue('A1', 'اسم');
$sheet->setCellValue('B1', 'العمر');
$sheet->setCellValue('C1', 'المهنة');

$sheet->setCellValue('A2', 'جون');
$sheet->setCellValue('B2', '35');
$sheet->setCellValue('C2', 'مهندس');

$sheet->setCellValue('A3', 'سارة');
$sheet->setCellValue('B3', '28');
$sheet->setCellValue('C3', 'محاسب');

// محاذاة البيانات في الجدول
$sheet->getStyle('A1:C1')->getAlignment()->setHorizontal(Alignment::HORIZONTAL_CENTER);

$filename = 'export.xlsx';

try {
    $writer = new Xlsx($spreadsheet);
    $writer->save($filename);
    
    // إرسال الملف للمستخدم
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment; filename="' . basename($filename) . '"');
    header('Expires: 0');
    header('Cache-Control: must-revalidate');
    header('Pragma: public');
    
    $writer->save('php://output');
    exit;
} catch (Exception $e) {
    echo "حدث خطأ أثناء إنشاء الملف: " . $e->getMessage();
}
?>